package editor;

import game.CustomImageDataII;

import java.awt.Color;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.File;

public class StaticBlockCanvasObject {
	
	private boolean isPassThrough;
	
	private CustomImageDataII image;
	
	
	
	public StaticBlockCanvasObject(CustomImageDataII theImage, boolean shouldBePassThrough) {
		isPassThrough = shouldBePassThrough;
		image = theImage;
	}
	
	
	public CustomImageDataII getImage() {
		return image;
	}
	
	public boolean isPassThrough() {
		return isPassThrough;
	}
	
	public void setImage(CustomImageDataII theImage) {
		image = theImage;
	}
	
	public void setPassThrough(boolean should)  {
		isPassThrough = should;
	}
	
	public StaticBlockCanvasObject(BufferedReader in, ImageObserver io, int tileWidth, int tileHeight) throws Exception {
		
		String inputter = null;
		
		String imageFile = null;
		Color transColor = null;
		
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("#"))
				continue;
			else if(inputter.contains("/blockDef"))
				break;
			else if(inputter.contains("solid")) {
				isPassThrough = false;
			} else if(inputter.contains("passThru")) {
				isPassThrough = true;
			} else if(inputter.contains("graphic:")) {
				imageFile = inputter.substring(8).trim();
			} else if(inputter.contains("transparent:")) {
				transColor = CustomAnimationPanel.convertStringToColor(inputter.substring(12).trim());
			}
		}
		
		image = new CustomImageDataII(new File(imageFile), transColor, io, tileWidth, tileHeight);
	}
	
}
